
-- remember keys for Rigidbodies. only care about default PRS controller (especially Euler_XYZ and Potion_XYZ parts)
-- then we can reset scene exactly as beginning. and get simulation determinism

-- global varible for storing node keys
global gPxRBKeys = #()

struct pxNodeKeys
(
	inode,
	posTimes = #(),
	posx = #(),
	posy = #(),
	posz = #(),
	rotTimes = #(),
	rotx = #(),
	roty = #(),
	rotz = #(),

	fn Init =
	(
		posTimes = #()
		posx = #()
		posy = #()
		posz = #()
		rotTimes = #()
		rotx = #()
		roty = #()
		rotz = #()
	),
	
	fn SaveKeys=
	(
		-- clear old data
		Init()
		
		-- save Position keys
		if classof(inode.position.controller) == Position_XYZ then
		(
			c = inode.position.controller;
			for i = 1 to c.keys.count do 
			(
				t = c.keys[i].time
				append posTimes t
				at time t
				(
					append posx c.x_position
					append posy c.y_position
					append posz c.z_position
				)
			)
		)
		
		-- save Rotation keys
		if classof(inode.rotation.controller) == Euler_XYZ then
		(
			c = inode.rotation.controller;
			for i = 1 to c.keys.count do 
			(
				t = c.keys[i].time
				append rotTimes t
				at time t
				(
					append rotx c.x_rotation
					append roty c.y_rotation
					append rotz c.z_rotation
				)
			)
		)
	),
	
	fn ResetKeys =
	(
		with animate on
		(
			-- reset position keys
			c = inode.position.controller
			
			-- check controller type because it may be changed by some other codes
			if classof(c) == Position_XYZ then
			(
				for i = 1 to posTimes.count do
				(
					at time posTimes[i]
					(
						c.x_position = posx[i]
						c.y_position = posy[i]
						c.z_position = posz[i]
					)
				)
			)
			
			-- reset rotation keys
			c = inode.rotation.controller
			
			-- check controller type because it may be changed by some other codes
			if classof(c) == Euler_XYZ then
			(
				for i = 1 to rotTimes.count do
				(
					at time rotTimes[i]
					(
						c.x_rotation = rotx[i]
						c.y_rotation = roty[i]
						c.z_rotation = rotz[i]
					)
				)
			)
		)
	),
	
	-- use the following function to test before calling SaveKeys() and ResetKeys()
	fn HaveKeys pnode =
	(
		if pnode != undefined and superclassof(pnode.baseobject) == GeometryClass and classof(pnode.controller) == PRS then
		(
			pnode.position.controller.keys.count > 0 or pnode.rotation.controller.keys.count > 0
		)
		else
		(
			false
		)
	)
)


fn PxClearSavedRBKeys =
(
	gPxRBKeys = #()
)

fn PxSaveRBKeys pnode =
(
	if pxNodeKeys.HaveKeys(pnode) then
	(
		global PxGetModRB
		modRB = PxGetModRB pnode
		
		-- do not care about baked nodes
		if modRB != undefined and (modRB.baked == 0) then
		(
			newkeys = pxNodeKeys pnode
			append gPxRBKeys newkeys
			gPxRBKeys[gPxRBKeys.count].SaveKeys()
		)
	)
)

fn PxResetRBKeys =
(
	for i in gPxRBKeys do
	(
		if (IsValidNode(i) == true) do
			i.ResetKeys()
	)
)
